/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.Color;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.client.gui.util.GuiNpcUtil;
import noppes.npcs.client.model.part.ModelData;
import noppes.npcs.client.util.ImageBufferDownloadAlt;
import noppes.npcs.client.util.ImageDownloadAlt;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.PlayerSkinController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.reflection.client.renderer.texture.TextureManagerReflection;
import noppes.npcs.reflection.client.resources.SkinManagerReflection;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderNPCInterface<T extends EntityNPCInterface>
extends RenderLiving<T> {
    private static final Map<Integer, Integer> transparentIDs = new HashMap<Integer, Integer>();
    private static final DynamicTexture TEXTURE_BRIGHTNESS = new DynamicTexture(16, 16);
    public static int LastTextureTick;

    public RenderNPCInterface(ModelBase model, float f) {
        super(Minecraft.func_71410_x().func_175598_ae(), model, f);
    }

    protected void applyRotations(@Nonnull T npc, float handleRotation, float rotationYaw, float partialTicks) {
        if (((EntityNPCInterface)((Object)npc)).func_70608_bn()) {
            GlStateManager.func_179114_b((float)((EntityNPCInterface)((Object)npc)).ais.orientation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.func_77037_a((EntityLivingBase)npc), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (((EntityNPCInterface)((Object)npc)).currentAnimation == 7) {
            GlStateManager.func_179114_b((float)(270.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            float scale = (float)((EntityNPCInterface)((Object)npc)).display.getSize() / 5.0f;
            GlStateManager.func_179109_b((float)(-scale + ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * scale), (float)0.14f, (float)0.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            if (((EntityNPCInterface)((Object)npc)).ais.getStandingType() == 4 && !((EntityNPCInterface)((Object)npc)).isAttacking() && !npc.func_70781_l()) {
                rotationYaw = ((EntityNPCInterface)((Object)npc)).ais.orientation;
            }
            super.func_77043_a(npc, handleRotation, rotationYaw, partialTicks);
        }
    }

    public void doRender(@Nonnull T npc, double x, double y, double z, float entityYaw, float partialTicks) {
        if (((EntityNPCInterface)((Object)npc)).func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g) || ((EntityNPCInterface)((Object)npc)).isKilled() && ((EntityNPCInterface)((Object)npc)).stats.hideKilledBody && ((EntityNPCInterface)((Object)npc)).field_70725_aQ > 20) {
            return;
        }
        if (((EntityNPCInterface)((Object)npc)).ais.getStandingType() == 3 && !((EntityNPCInterface)((Object)npc)).isWalking() && !((EntityNPCInterface)((Object)npc)).isInteracting()) {
            float n;
            ((EntityNPCInterface)((Object)npc)).field_70761_aq = n = (float)((EntityNPCInterface)((Object)npc)).ais.orientation;
            ((EntityNPCInterface)((Object)npc)).field_70760_ar = n;
        }
        try {
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            RenderHelper.func_74519_b();
            super.func_76986_a(npc, x, y, z, entityYaw, partialTicks);
            RenderHelper.func_74519_b();
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void func_76979_b(@Nonnull Entity entity, double par2, double par4, double par6, float par8, float par9) {
        EntityNPCInterface npc = (EntityNPCInterface)entity;
        this.field_76989_e = npc.field_70130_N / 1.25f * npc.display.shadowSize;
        if (!npc.isKilled()) {
            this.field_76987_f = npc.display.getVisible() == 1 && npc.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g) ? 0.0f : (npc.display.getVisible() == 2 && Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() != CustomRegisters.wand ? 0.3f : 1.0f);
            super.func_76979_b(entity, par2, par4, par6, par8, par9);
        }
    }

    public ResourceLocation getEntityTexture(@Nonnull T npc) {
        return RenderNPCInterface.getNpcTexture(npc);
    }

    public static ResourceLocation getNpcTexture(EntityNPCInterface npc) {
        Map<MinecraftProfileTexture.Type, ResourceLocation> map;
        PlayerSkinController pData;
        boolean isEmpty;
        boolean bl = isEmpty = npc.textureLocation == null || npc.textureLocation.func_110623_a().isEmpty();
        if (isEmpty) {
            if (npc.display.skinType == 0) {
                npc.textureLocation = new ResourceLocation(npc.display.getSkinTexture());
            } else {
                if (LastTextureTick < 5) {
                    return DefaultPlayerSkin.func_177335_a();
                }
                if (npc.display.skinType == 1) {
                    if (npc.display.playerProfile == null) {
                        npc.display.loadProfile();
                    }
                    if (npc.display.playerProfile != null) {
                        pData = PlayerSkinController.getInstance();
                        map = pData.getData(npc.display.playerProfile.getId());
                        if (map != null && map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            npc.textureLocation = map.get(MinecraftProfileTexture.Type.SKIN);
                        } else {
                            Minecraft minecraft = Minecraft.func_71410_x();
                            Map mapMC = minecraft.func_152342_ad().func_152788_a(npc.display.playerProfile);
                            if (mapMC.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                                npc.textureLocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)mapMC.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                            }
                        }
                    }
                } else if (npc.display.skinType == 2) {
                    try {
                        boolean fixSkin = npc instanceof EntityCustomNpc && ((EntityCustomNpc)npc).modelData.getEntity(npc) == null;
                        File file = new File(SkinManagerReflection.getDir(Minecraft.func_71410_x().func_152342_ad()), "" + (npc.display.getSkinUrl() + fixSkin).hashCode());
                        npc.textureLocation = new ResourceLocation("customnpcs", "skins/" + (npc.display.getSkinUrl() + fixSkin).hashCode() + (fixSkin ? "" : "32"));
                        RenderNPCInterface.loadSkin(file, npc.textureLocation, npc.display.getSkinUrl());
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                }
            }
        }
        boolean bl2 = isEmpty = npc.textureLocation == null || npc.textureLocation.func_110623_a().isEmpty();
        if (isEmpty) {
            npc.textureLocation = DefaultPlayerSkin.func_177335_a();
            npc.display.setSkinTexture(npc.textureLocation.toString());
        } else if (npc.display.skinType == 1 && LastTextureTick % 100 == 0) {
            if (npc.display.playerProfile == null) {
                npc.display.loadProfile();
            }
            if (npc.display.playerProfile != null && (map = (pData = PlayerSkinController.getInstance()).getData(npc.display.playerProfile.getId())) != null && map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                npc.textureLocation = map.get(MinecraftProfileTexture.Type.SKIN);
            }
        }
        return npc.textureLocation;
    }

    protected boolean bindEntityTexture(@Nonnull T entity) {
        ResourceLocation resourcelocation = this.getEntityTexture(entity);
        if (resourcelocation == null) {
            return false;
        }
        GuiNpcUtil.bindEntityTexture(this.field_76990_c.field_78724_e, resourcelocation);
        return true;
    }

    protected float handleRotationFloat(@Nonnull T npc, float par2) {
        if (((EntityNPCInterface)((Object)npc)).isKilled() || !((EntityNPCInterface)((Object)npc)).display.getHasLivingAnimation()) {
            return 0.0f;
        }
        return super.func_77044_a(npc, par2);
    }

    private static void loadSkin(File file, ResourceLocation resource, String url) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Map<ResourceLocation, ITextureObject> mapTextureObjects = TextureManagerReflection.getMapTextureObjects(texturemanager);
        if (!mapTextureObjects.containsKey(resource)) {
            ImageDownloadAlt object = new ImageDownloadAlt(file, url, DefaultPlayerSkin.func_177335_a(), (IImageBuffer)new ImageBufferDownloadAlt());
            texturemanager.func_110579_a(resource, (ITextureObject)object);
        }
    }

    protected void preRenderCallback(@Nonnull T npc, float f) {
        this.renderColor((EntityNPCInterface)((Object)npc));
        int size = ((EntityNPCInterface)((Object)npc)).display.getSize();
        GlStateManager.func_179152_a((float)(((EntityNPCInterface)((Object)npc)).scaleX / 5.0f * (float)size), (float)(((EntityNPCInterface)((Object)npc)).scaleY / 5.0f * (float)size), (float)(((EntityNPCInterface)((Object)npc)).scaleZ / 5.0f * (float)size));
    }

    protected void renderColor(EntityNPCInterface npc) {
        if (npc.animation.isAnimated(AnimationKind.DIES) && npc.field_70737_aN <= 0 && npc.field_70725_aQ <= 0) {
            float red = (float)(npc.display.getTint() >> 16 & 0xFF) / 255.0f;
            float green = (float)(npc.display.getTint() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(npc.display.getTint() & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
        }
    }

    protected void renderLivingAt(@Nonnull T npc, double d, double d1, double d2) {
        this.field_76989_e = (float)((EntityNPCInterface)((Object)npc)).display.getSize() / 10.0f;
        float xOffset = 0.0f;
        float yOffset = ((EntityNPCInterface)((Object)npc)).currentAnimation == 0 ? ((EntityNPCInterface)((Object)npc)).ais.bodyOffsetY / 10.0f - 0.5f : 0.0f;
        float zOffset = 0.0f;
        if (((EntityNPCInterface)((Object)npc)).func_70089_S()) {
            if (((EntityNPCInterface)((Object)npc)).func_70608_bn()) {
                xOffset = (float)(-Math.cos(Math.toRadians(180 - ((EntityNPCInterface)((Object)npc)).ais.orientation)));
                zOffset = (float)(-Math.sin(Math.toRadians(((EntityNPCInterface)((Object)npc)).ais.orientation)));
                yOffset += 0.14f;
            } else if (((EntityNPCInterface)((Object)npc)).currentAnimation == 1 || npc.func_184218_aH()) {
                yOffset -= 0.5f - ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * 0.8f;
            }
        }
        xOffset = xOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        yOffset = yOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        zOffset = zOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        super.func_77039_a(npc, d + (double)xOffset, d1 + (double)yOffset, d2 + (double)zOffset);
    }

    protected void renderLivingLabel(EntityNPCInterface npc, double x, double y, double z, String name, String title) {
        FontRenderer fontrenderer = this.func_76983_a();
        float f1 = npc.baseHeight / 5.0f * (float)npc.display.getSize();
        float f2 = 0.01666667f * f1;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        ModelData modeldata = ((EntityCustomNpc)npc).modelData;
        float height = (f1 + (modeldata != null && (modeldata.getPartData(EnumParts.HORNS) != null || modeldata.getPartData(EnumParts.MOHAWK) != null) ? 1.0f : 0.0f)) / 6.5f * 2.0f;
        Color c = new Color((float)(npc.getFaction().color >> 16 & 0xFF) / 255.0f, (float)(npc.getFaction().color >> 8 & 0xFF) / 255.0f, (float)(npc.getFaction().color & 0xFF) / 255.0f, (float)(npc.getFaction().color >> 24 & 0xFF) / 255.0f);
        boolean isInvisible = false;
        if (npc.display.getVisible() == 1) {
            isInvisible = npc.display.getAvailability().isAvailable((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        } else if (npc.display.getVisible() == 2) {
            isInvisible = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() != CustomRegisters.wand;
        }
        c = new Color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, isInvisible ? 0.3f : 1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179109_b((float)0.0f, (float)height, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (name.isEmpty()) {
            float f3 = 0.01666667f * f1 * 0.6f;
            GlStateManager.func_179109_b((float)0.0f, (float)(-f1 / 6.5f * 0.9f), (float)0.0f);
            GlStateManager.func_179152_a((float)(-f3), (float)(-f3), (float)f3);
            fontrenderer.func_78276_b(title, -fontrenderer.func_78256_a(title) / 2, 0, c.getRGB());
            GlStateManager.func_179152_a((float)(1.0f / -f3), (float)(1.0f / -f3), (float)(1.0f / f3));
            GlStateManager.func_179109_b((float)0.0f, (float)(f1 / 6.5f * 0.85f), (float)0.0f);
        } else if (!title.isEmpty()) {
            title = "<" + title + ">";
            float f3 = 0.01666667f * f1 * 0.6f;
            GlStateManager.func_179109_b((float)0.0f, (float)(-f1 / 6.5f * 0.4f), (float)0.0f);
            GlStateManager.func_179152_a((float)(-f3), (float)(-f3), (float)f3);
            fontrenderer.func_78276_b(title, -fontrenderer.func_78256_a(title) / 2, 0, c.getRGB());
            GlStateManager.func_179152_a((float)(1.0f / -f3), (float)(1.0f / -f3), (float)(1.0f / f3));
            GlStateManager.func_179109_b((float)0.0f, (float)(f1 / 6.5f * 0.85f), (float)0.0f);
        }
        GlStateManager.func_179152_a((float)(-f2), (float)(-f2), (float)f2);
        if (npc.isInRange(this.field_76990_c.field_78734_h, 4.0) && !name.isEmpty()) {
            GlStateManager.func_179097_i();
            c = new Color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, isInvisible ? 0.225f : 1.0f);
            fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, 0, c.getRGB());
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!name.isEmpty()) {
            fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, 0, c.getRGB());
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    protected void renderModel(@Nonnull T npc, float par2, float par3, float par4, float par5, float par6, float par7) {
        boolean isInvisible = false;
        if (((EntityNPCInterface)((Object)npc)).display.getVisible() == 1) {
            isInvisible = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() != CustomRegisters.wand && ((EntityNPCInterface)((Object)npc)).display.getAvailability().isAvailable((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        } else if (((EntityNPCInterface)((Object)npc)).display.getVisible() == 2) {
            boolean bl = isInvisible = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() != CustomRegisters.wand;
        }
        if (this.bindEntityTexture(npc)) {
            if (isInvisible) {
                int textureId = GL11.glGetInteger((int)32873);
                if (!transparentIDs.containsKey(textureId)) {
                    int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                    int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                    ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
                    GL11.glBindTexture((int)3553, (int)textureId);
                    GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                    for (int i = 0; i < width * height; ++i) {
                        int offset = i * 4 + 3;
                        buffer.put(offset, (byte)((buffer.get(offset) & 0xFF) / 2));
                    }
                    int newTextureId = GL11.glGenTextures();
                    GL11.glBindTexture((int)3553, (int)newTextureId);
                    GL11.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
                    GL11.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                    transparentIDs.put(textureId, newTextureId);
                }
                GL11.glBindTexture((int)3553, (int)transparentIDs.get(textureId));
            }
            this.field_77045_g.func_78088_a(npc, par2, par3, par4, par5, par6, par7);
        }
        if (!((EntityNPCInterface)((Object)npc)).display.getOverlayTexture().isEmpty()) {
            GlStateManager.func_179143_c((int)515);
            if (((EntityNPCInterface)((Object)npc)).textureGlowLocation == null) {
                ((EntityNPCInterface)((Object)npc)).textureGlowLocation = new ResourceLocation(((EntityNPCInterface)((Object)npc)).display.getOverlayTexture());
            }
            this.func_110776_a(((EntityNPCInterface)((Object)npc)).textureGlowLocation);
            float f1 = 1.0f;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)1, (int)1);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((!isInvisible ? 1 : 0) != 0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)1.001f, (float)1.001f, (float)1.001f);
            this.field_77045_g.func_78088_a(npc, par2, par3, par4, par5, par6, par7);
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179084_k();
        }
    }

    public void renderName(@Nonnull T npc, double d, double d1, double d2) {
        if (!this.func_177070_b((EntityLiving)npc) || this.field_76990_c.field_78734_h == null) {
            return;
        }
        double d3 = npc.func_70032_d(this.field_76990_c.field_78734_h);
        if (d3 > 512.0) {
            return;
        }
        if (((EntityNPCInterface)((Object)npc)).messages != null) {
            float height = ((EntityNPCInterface)((Object)npc)).baseHeight / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
            float offset = ((EntityNPCInterface)((Object)npc)).field_70131_O * (1.2f + (((EntityNPCInterface)((Object)npc)).display.showName() ? (((EntityNPCInterface)((Object)npc)).display.getTitle().isEmpty() ? 0.15f : 0.25f) : 0.0f));
            ((EntityNPCInterface)((Object)npc)).messages.renderMessages(d, d1 + (double)offset, d2, 0.666667f * height, ((EntityNPCInterface)((Object)npc)).isInRange(this.field_76990_c.field_78734_h, 4.0));
        }
        float scale = ((EntityNPCInterface)((Object)npc)).baseHeight / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        if (((EntityNPCInterface)((Object)npc)).display.showName()) {
            if (((EntityNPCInterface)((Object)npc)).currentAnimation == 1) {
                d1 -= (double)0.35f;
            }
            this.renderLivingLabel((EntityNPCInterface)((Object)npc), d, d1 + (double)((EntityNPCInterface)((Object)npc)).field_70131_O - (double)(0.06f * scale), d2, ((EntityNPCInterface)((Object)npc)).func_70005_c_(), ((EntityNPCInterface)((Object)npc)).display.getTitle());
            if (!CustomNpcs.ShowLR) {
                return;
            }
            NoppesUtilPlayer.sendDataCheckDelay(EnumPlayerPacket.NpcVisualData, npc, 5000L, npc.func_145782_y());
            if (!((EntityNPCInterface)((Object)npc)).stats.getRarityTitle().isEmpty()) {
                this.renderLivingLabel((EntityNPCInterface)((Object)npc), d, d1 + (double)((EntityNPCInterface)((Object)npc)).field_70131_O - (double)(0.06f * scale), d2, "", ((EntityNPCInterface)((Object)npc)).stats.getRarityTitle());
            }
        }
    }

    protected boolean setBrightness(@Nonnull T npc, float partialTicks, boolean combineTextures) {
        boolean isHurt;
        float f = npc.func_70013_c();
        int color = this.func_77030_a((EntityLivingBase)npc, f, partialTicks);
        boolean hasColor = (color >> 24 & 0xFF) > 0;
        boolean bl = isHurt = !((EntityNPCInterface)((Object)npc)).animation.isAnimated(AnimationKind.DIES) && ((EntityNPCInterface)((Object)npc)).field_70737_aN > 0 || ((EntityNPCInterface)((Object)npc)).field_70725_aQ > 0;
        if (!hasColor && !isHurt) {
            return false;
        }
        if (!hasColor && !combineTextures) {
            return false;
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)OpenGlHelper.field_176094_t);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176092_v);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176080_A, (int)OpenGlHelper.field_176092_v);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176076_D, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        this.field_177095_g.position(0);
        if (isHurt) {
            this.field_177095_g.put(1.0f);
            this.field_177095_g.put(0.0f);
            this.field_177095_g.put(0.0f);
            this.field_177095_g.put(0.3f);
        } else {
            this.field_177095_g.put((float)(color >> 16 & 0xFF) / 255.0f);
            this.field_177095_g.put((float)(color >> 8 & 0xFF) / 255.0f);
            this.field_177095_g.put((float)(color & 0xFF) / 255.0f);
            this.field_177095_g.put(1.0f - (float)(color >> 24 & 0xFF) / 255.0f);
        }
        this.field_177095_g.flip();
        GlStateManager.func_187448_b((int)8960, (int)8705, (FloatBuffer)this.field_177095_g);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)TEXTURE_BRIGHTNESS.func_110552_b());
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        return true;
    }
}

